<?php if ( !is_user_logged_in() ) {
	wp_redirect('login');
	exit();
}
$current_user = wp_get_current_user();
$user_id = $current_user->ID;

if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) ) {
	require 'include/template/account/update.php';
}

get_header(); ?>

<div class="bg-lightest pd-v-lg">

	<div class="container text-center space-2">

		<h1 class="text-heading text-huge"><?php the_title(); ?></h1>
		<?php if ( current_user_can('editor') || current_user_can('administrator') ) { ?>

		<div class="container text-center">

			<a href="/wp-admin/" class="btn btn-primary">Go to Admin Panel</a>

		</div>
		<?php } ?>

	</div>

	<div class="container">

<?php if ( isset($_GET["action"]) && $_GET["action"] == 'edit' ) { ?>

	<?php require 'include/template/account/account-details-form.php'; ?>
	
<?php } else { ?>

	<div class="container">
		<?php 
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		//Get all user details 
		$title = get_user_meta( $user_id, 'title', true );
		$first_name = get_user_meta( $user_id, 'first_name', true );
		$last_name = get_user_meta( $user_id, 'last_name', true );
		$last_name = get_user_meta( $user_id, 'last_name', true );

		$company = get_user_meta( $user_id, 'company', true );
		$line1 = get_user_meta( $user_id, 'billing_address_1', true );
		$line2 = get_user_meta( $user_id, 'billing_address_2', true );
		$line3 = get_user_meta( $user_id, 'billing_address_3', true );
		$town = get_user_meta( $user_id, 'billing_town', true );
		$postcode = get_user_meta( $user_id, 'billing_postcode', true );
		$tel = get_user_meta( $user_id, 'telephone_number', true );
		$email = $current_user->user_email
		?>

			<div class="col-6 col-12-sm space-2-sm">

					<h3 class="space-1">Account Details</h3>

					<p><address>
						<?php if ( !empty($title) && !empty($first_name) && !empty($last_name) ) {
							echo ucfirst($title) . " " . $first_name . " " . $last_name . "<br />";
						}
						if ( !empty($company) ) {
							echo $company . "<br />";
						}
						if ( !empty($line1) ) {
							echo $line1 . "<br />";
						}
						if ( !empty($line2) ) {
							echo $line2 . "<br />";
						}
						if ( !empty($line3) ) {
							echo $line3 . "<br />";
						}
						if ( !empty($town) ) {
							echo $town . "<br />";
						}
						if ( !empty($postcode) ) {
							echo $postcode . "<br />";
						} 
						?>
					</address></p>
					<p class="space-1">
					<?php if ( !empty($tel) ) {
							echo "Tel: <strong>" . $tel . "</strong><br />";
						}
						if ( !empty($email) ) {
							echo "Email: <strong>" . $email . "</strong>";
						} ?>
					</p>
					<a href="<?php echo site_url('/account/?action=edit'); ?>" class="btn btn-secondary">Edit Details</a>&nbsp;&nbsp; <a href="<?php echo wp_logout_url( '/' ); ?>">Logout</a>

			</div>

			<div class="col-6 col-12-sm">

					<h3 class="space-1">Previous Orders</h3>
					<?php

$args = array(
	'post_type' => 'orders',
	'author' => $user_id,
		'meta_query' => array(
		array(
			'key'     => 'order_status',
			'value'   => array( 3, 4, 5 ),
			'compare' => 'IN',
		),
	),
);
$orders = new WP_Query( $args );

// The Loop
if ( $orders->have_posts() ) { ?>

	<table class="table">

		<tr>
			<th>Order No.</th>
			<th>Date</th>
			<th>Status</th>
		</tr>

	<?php while ( $orders->have_posts() ) {
		$orders->the_post();
		$status = get_post_meta( $post->ID, 'order_status', true );
		if ( $status == 5 ) {
			$status = '<span style="color:red;">Cancelled</span>';
		}
		if ( $status == 4 ) {
			$status = '<span style="color:green;">Dispatched</span>';
		}
		if ( $status == 3 ) {
			$status = '<span style="color:orange;">Processing</span>';
		}
		?>

		<tr>
			<td><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></td>
			<td><?php echo get_the_date(); ?></td>
			<td><?php echo $status; ?></td>
		</tr>

	<?php } ?>

	</table>

<?php } else {
	echo 'No orders placed.';
}
wp_reset_postdata(); ?>

		</div>

	</div>
<?php } ?>

</div>

</div>

<?php get_footer(); ?>