<?php
//include 'include/function/admin-functions.php';
//include 'include/function/rewrites.php';
//include 'include/function/custom-post-types.php';
include 'include/function/menus.php';
//include 'include/function/basket-functions.php';
//include 'include/function/order-functions.php';
//include 'include/function/product-functions.php';
//include 'include/function/voucher-functions.php';
include 'include/function/form-functions.php';
//include 'include/function/report-functions.php';
//include 'include/function/user-functions.php';
include 'include/function/sitemap.php';
include 'include/function/woocommerce.php';

$loadShop = new Shop();

//Define image sizes
if ( function_exists( 'add_theme_support' ) ) { 
  add_image_size( 'hero', 2000, 1000 ); 
  add_image_size( 'fullsize', 2000, 2000 ); 
  add_image_size( 'large-1x1', 1200, 1200, true ); 
  add_image_size( 'large-4x3', 1200, 800, true );
  add_image_size( 'large-3x4', 387, 1200 );
  add_image_size( 'medium-1x1', 800, 800, true );
  add_image_size( 'medium-4x3', 800, 533, true );
  add_image_size( 'medium-3x4', 258, 800 );
  add_image_size( 'small-1x1', 480, 480, true );
  add_image_size( 'small-4x3', 480, 320, true );
  add_image_size( 'small-3x4', 155, 480 );
  add_theme_support( 'woocommerce' );
}

//Remove default image sizes
function remove_default_image_sizes($sizes) {
  unset( $sizes['small'] );
  unset( $sizes['medium'] );
  unset( $sizes['large'] );
  unset( $sizes['medium_large'] );
  return $sizes;
}
add_filter('intermediate_image_sizes_advanced', 'remove_default_image_sizes');

//Allow SCV image uploads
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

//Admin panel Google Maps
add_filter('acf/settings/google_api_key', function ($value) {
  return 'AIzaSyDwW2CpVOk3Eq0d3b09mcfshhNQqCt8IEY';
});

//Enqueue scripts
function city_scripts() {
  wp_enqueue_style( 'stylesheet', get_template_directory_uri() . '/css/styles.css', array(), '1.0.06' );
  //wp_enqueue_script( 'scripts', get_template_directory_uri() . '/js/vendor/jquery.js', array(), '1.12.4', true );
  $conditional_scripts = array(
    'html5shiv'   => 'https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js',
    'placeholder' => get_template_directory_uri() . '/js/vendor/placeholder.min.js'
  );
  foreach ( $conditional_scripts as $handle => $src ) {
    wp_enqueue_script( $handle, $src, array(), '', true );
  }
  add_filter( 'script_loader_tag', function( $tag, $handle ) use ( $conditional_scripts ) {
    if ( array_key_exists( $handle, $conditional_scripts ) ) {
      $tag = "<!--[if lte IE 9]>" . $tag . "<![endif]-->";
    }
    return $tag;
  }, 10, 2 );
  wp_enqueue_script('jquery');
  wp_enqueue_script( 'plugins', get_template_directory_uri() . '/js/vendor/plugins.js', array(), '1', true );
  //wp_enqueue_script( 'google-maps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDwW2CpVOk3Eq0d3b09mcfshhNQqCt8IEY', array(), NULL, true );
 // wp_enqueue_script( 'map', get_template_directory_uri() . '/js/map.js', array(), '1', true );
  wp_enqueue_script( 'custom-scripts', get_template_directory_uri() . '/js/scripts.js', array(), '1', true );
}
add_action( 'wp_enqueue_scripts', 'city_scripts' );

//Admin panel settings
if( function_exists('acf_add_options_page') ) {
  acf_add_options_page(array(
    'page_title'  => 'Settings',
    'menu_title'  => 'Settings',
    'menu_slug'   => 'contact-details',
    'capability'  => 'publish_posts',
    'redirect'    => true
  ));
}

function limit_text($text, $limit) {
  if (str_word_count($text, 0) > $limit) {
    $words = str_word_count($text, 2);
    $pos = array_keys($words);
    $text = substr($text, 0, $pos[$limit]) . '...';
  }
  return $text;
}

function custom_excerpt_length( $length ) {
    return 18;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function new_excerpt_more($more) {
  global $post;
  return '...';
}
add_filter('excerpt_more', 'new_excerpt_more');

//Admin panel menu
function custom_menu_order($menu_ord) {
    if (!$menu_ord) return true;
    return array(
      'index.php',
      'edit.php?post_type=orders',
      'separator1',
      'edit.php?post_type=page',
      'edit.php?post_type=vineyard',
      'edit.php?post_type=product',
      'edit.php?post_type=voucher',
      'users.php',
      'separator2'
    );
}
add_filter('custom_menu_order', 'custom_menu_order');
add_filter('menu_order', 'custom_menu_order');

function custom_single_template($single) {
  //Basket
  if( is_page('basket') ) {
    return TEMPLATEPATH . '/basket.php';
  }
  //Account
  if( is_page('account') ) {
    return TEMPLATEPATH . '/account.php';
  }
  //Checkout
  if( is_page('checkout') ) {
    return TEMPLATEPATH . '/checkout.php';
  }
  //Login
  if( is_page('login') ) {
    return TEMPLATEPATH . '/login.php';
  }
  //Login
  if( is_page('callback') ) {
    return TEMPLATEPATH . '/callback.php';
  }
  return $single;
}
//add_filter('page_template', 'custom_single_template');

function redir_404_wpse_137703() {
  if (is_404() && isset($_GET['name'])) {
    return TEMPLATEPATH . '/callback.php';
    exit;
  }
}
add_action('template_redirect','redir_404_wpse_137703');

function pagination($pages = '', $range = 4) {
  $showitems = ($range * 2)+1;  
  global $paged;
  if( empty( $paged ) ) $paged = 1;
  if ( $pages == '' ) {
    global $wp_query;
    $pages = $wp_query->max_num_pages;
    if ( !$pages ) {
      $pages = 1;
    }
  }   
  if ( 1 != $pages) {
    if( !isset( $_GET['viewCount']) ) {
      echo "<nav class=\"container pagination\">";
      echo "<ul class=\"no-list\">";
      if( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) echo "<li><a href='".get_pagenum_link(1)."'>&laquo; First</a></li>";
      if( $paged > 1 && $showitems < $pages ) echo "<li><a href='".get_pagenum_link($paged - 1)."'>&lsaquo; Previous</a></li>";
      for ($i=1; $i <= $pages; $i++) {
        if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))  {
          echo ($paged == $i)? "<li><span class=\"pagination-current\">".$i."</span></li>":"<li><a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a></li>";
        }
      }
      if ($paged < $pages && $showitems < $pages) echo "<li><a href=\"".get_pagenum_link($paged + 1)."\">Next &rsaquo;</a></li>";  
      if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($pages)."'>Last &raquo;</a></li>";
      echo "</ul>\n";
      echo "</nav>\n";
    }
  }
}

function slugify($text) {
  $text = preg_replace('~[^\pL\d]+~u', '-', $text);
  $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
  $text = preg_replace('~[^-\w]+~', '', $text);
  $text = trim($text, '-');
  $text = preg_replace('~-+~', '-', $text);
  $text = strtolower($text);
  if ( empty($text) ) {
    return 'n-a';
  }
  return $text;
}

add_filter( 'wp_mail_content_type', 'set_content_type' );
function set_content_type( $content_type ) {
	return 'text/html';
}

// check that cart items quantities totals are in multiples of 6
add_action( 'woocommerce_check_cart_items', 'woocommerce_check_cart_quantities' );
function woocommerce_check_cart_quantities() {
    $multiples = 12;
  $total_products = 0;
  foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
    $total_products += $values['quantity'];
  }
  if ( ( $total_products % $multiples ) > 0 )
    wc_add_notice( sprintf( __('Please make sure you order bottles in multiples of %s to fill a case.', 'woocommerce'), $multiples ), 'error' );
}

// Limit cart items with a certain shipping class to be purchased in multiple only
add_action( 'woocommerce_check_cart_items', 'woocommerce_check_cart_quantities_for_class' );
function woocommerce_check_cart_quantities_for_class() {
    $multiples = 12;
    $class = 'bottle';
  $total_products = 0;
  foreach ( WC()->cart->get_cart() as $cart_item_key => $values ) {
    $product = get_product( $values['product_id'] );
    if ( $product->get_shipping_class() == $class ) {
      $total_products += $values['quantity'];
    }
  }
  if ( ( $total_products % $multiples ) > 0 )
    wc_add_notice( sprintf( __('Please make sure you order bottles in multiples of %s to fill a case.', 'woocommerce'), $multiples ), 'error' );
}


function populateTasteTab() {
    $colour = get_field('colour');
    $nose = get_field('nose');
    $on_the_palate = get_field('on_the_palate');
    $serving_suggestions = get_field('serving_suggestions');
?>
    <div id="tasting-notes" class="content">
        <?php if ( $colour ) { ?>

          <span class="text-bold">Colour:</span><br>

          <?php echo $colour; ?>
        <?php } ?>
        <?php if ( $nose ) { ?>

          <span class="text-bold">Nose:</span><br>

          <?php echo $nose; ?>
        <?php } ?>
        <?php if ( $on_the_palate ) { ?>

          <span class="text-bold">On The Palate:</span><br>

          <?php echo $on_the_palate; ?>
        <?php } ?>
        <?php if ( $serving_suggestions ) { ?>

          <br>

          <span class="text-bold">Serving Suggestions:</span><br>
          <?php foreach ($serving_suggestions as $serving) { ?>
        
          <p>

            <span class="text-quote">&#34;<?php echo $serving['suggestion']; ?>&#65282;</span><br>

            <span class="text-bold"><?php echo $serving['author']; ?></span><br>

            <span class="text-faded text-meta"><?php echo $serving['location']; ?></span>

          </p>
          <?php } ?>
        <?php } ?>
    </div>
<?php
}

add_action( 'woocommerce_register_form', 'bbloomer_add_registration_age_verification', 11 );
   
function bbloomer_add_registration_age_verification() {
 
    woocommerce_form_field( 'age_verification', array(
        'type'          => 'checkbox',
        'class'         => array('form-row age-verification'),
        'label_class'   => array('woocommerce-form__label woocommerce-form__label-for-checkbox checkbox'),
        'input_class'   => array('woocommerce-form__input woocommerce-form__input-checkbox input-checkbox'),
        'required'      => true,
        'label'         => '<span>I am over 18 years of age</span>',
    ));
}
  
// Show error if user does not tick
add_filter( 'woocommerce_registration_errors', 'bbloomer_validate_age_registration', 10, 3 );
  
function bbloomer_validate_age_registration( $errors, $username, $email ) {
    if ( ! is_checkout() ) {
        if ( ! (int) isset( $_POST['age_verification'] ) ) {
            $errors->add( 'age_verification_error', __( 'Age verification is required!', 'woocommerce' ) );
        }
    }
    return $errors;
}


//privacy & terms checkbox
add_action( 'woocommerce_register_form', 'bbloomer_add_registration_privacy_verification', 11 );
function bbloomer_add_registration_privacy_verification() {
 
    woocommerce_form_field( 'privacy', array(
        'type'          => 'checkbox',
        'class'         => array('form-row privacy'),
        'label_class'   => array('woocommerce-form__label woocommerce-form__label-for-checkbox checkbox'),
        'input_class'   => array('woocommerce-form__input woocommerce-form__input-checkbox input-checkbox'),
        'required'      => true,
        'label'         => '<span>I have read and accepted the <a href="https://www.dysonwine.com/privacy" target="_blank"><strong>privacy policy</strong></a> and <a href="https://www.dysonwine.com/terms" target="_blank"><strong>terms &amp; conditions</strong></a></span>',
    ));
}
// Show error if user does not tick
add_filter( 'woocommerce_registration_errors', 'bbloomer_validate_privacy_registration', 10, 3 );
function bbloomer_validate_privacy_registration( $errors, $username, $email ) {
    if ( ! is_checkout() ) {
        if ( ! (int) isset( $_POST['privacy'] ) ) {
            $errors->add( 'privacy_verification_error', __( 'Please agree to terms & conditions!', 'woocommerce' ) );
        }
    }
    return $errors;
}