<?php
function template_url($ex) {
    return get_bloginfo('template_directory').'/'.$ex;
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<title>Domaine des Rabelles | Vineyard Provence, France | Dyson Wine></title>

	<link rel="apple-touch-icon" sizes="180x180" href="<?php echo template_url('img/icon/apple-touch-icon.png'); ?>">
	<link rel="icon" type="image/png" sizes="32x32" href="<?php echo template_url('img/icon/favicon-32x32.png'); ?>">
	<link rel="icon" type="image/png" sizes="16x16" href="<?php echo template_url('img/icon/favicon-16x16.png'); ?>">
	<link rel="manifest" href="<?php echo template_url('img/icon/site.webmanifest'); ?>">
	<link rel="mask-icon" href="<?php echo template_url('img/icon/safari-pinned-tab.svg'); ?>" color="#5bbad5">
	<link rel="shortcut icon" href="<?php echo template_url('img/icon/favicon.ico'); ?>">
	<meta name="msapplication-TileColor" content="#2d89ef">
	<meta name="msapplication-config" content="<?php echo template_url('img/icon/browserconfig.xml'); ?>">
	<meta name="theme-color" content="#ffffff">
	<?php wp_head(); ?>

</head>

<body <?=body_class();?>>

<div id="header-wrap">

	<header id="header">

		<div class="container">

			<a href="/" title="Home" class="header-logo text-center">

				<div class="header-logo-inner">

					<img src="<?php echo template_url('img/logo.svg'); ?>" width="90" height="74" alt="Logo" class="img-logo space-0" />

					<h1 class="h4 text-black">Dyson<span class="text-faded">Wine</span></h1>

				</div>
				
			</a>
			<?php if ( !is_page('checkout') ) { ?>

			<nav id="main">

				<ul class="container">

					<li class="show-md space-2">

						<a href="/" title="Home">

							<img src="<?php echo template_url('img/logo.svg'); ?>" width="85" height="70" alt="Logo" class="space-1" />

							<h1 class="h5">Dyson Wine</h1>

						</a>

					</li>

					<li style="visibility:hidden;" <?php if ( is_page('wine') || get_field('type') && get_field('type') == 'wine'  ) { echo ' class="current-menu-item"'; } ?>><a href="<?php echo site_url('wine'); ?>" title="Wine"><span>&nbsp;Wine&nbsp;</span></a></li>

					<li<?php if ( is_page('about') ) { echo ' class="current-menu-item"'; } ?>><a href="<?php echo site_url('about'); ?>" title="About"><span>&nbsp; A Propos &nbsp;</span></a></li>

					<li<?php if ( is_page('vignoble') ) { echo ' class="current-menu-item"'; } ?>><a href="<?php echo site_url('vignoble'); ?>" title="Vignoble"><span>Vignoble</span></a></li>

					<li<?php if ( is_page('Contact') ) { echo ' class="current-menu-item"'; } ?>><a href="<?php echo site_url('contact'); ?>" title="Contact"><span>Contact</span></a></li>

					<li class="show-md mobile-link"><div class="row">Website by <br><a href="https://www.838888.co.uk" title="Web design Lincolnshire" target="_blank" rel="noopener">City Graphics Partnership</a></div></li>

				</ul>

			</nav>

			<nav id="mobile" class="text-center show-md">
				
				<ul>
                    <li><?php echo do_shortcode("[language-switcher]"); ?></li>
					<li><a href="/basket/" title="Basket"><div class="nav-header-icon"><i class="icon-basket"></i><?php echo '<span class="notification-count">' .  WC()->cart->get_cart_contents_count() . '</span>'; ?></div> <span class="sub-title">Basket</span></a></li>
					
					<li><a href="/account/" title="My Account"><div class="nav-header-icon"><i class="icon-account"></i></div> <span class="sub-title">Account</span></a></li>
					
					<li><a href="#" title="Menu" class="menu"><div class="nav-header-icon"><div class="nav-header-icon"><span></span></div></div> <span class="sub-title">Menu</span></a></li>
				
				</ul>
			
			</nav>

			<div id="header-basket" class="hide-md bg-lighter pd-h-sm"> 

				<ul>
				    
					<?php if ( is_user_logged_in() ) { ?>

					<li>

						<a href="<?php echo site_url('account'); ?>" title="Account" class="text-black"><span class="text-meta">Account</span></a>

					</li>
					<?php } else { ?>
						
					<li>

						<a href="<?php echo site_url('login'); ?>" title="Login" class="text-black"><span class="text-meta">Join / Login</span></a>

					</li>
					<?php } ?>

					<li>

						<a href="<?php echo site_url('basket'); ?>" title="Basket" class="text-black"><i class="icon-basket"></i><?php echo '<span class="notification-count">' .  WC()->cart->get_cart_contents_count() . '</span>'; ?></div></a>

					</li>

				</ul>

			</div>
			<?php } ?>

		</div>

	</header>

</div>