<?php
/*************************************
	 ___ ____ ___  ___  ___  ___ 
	( _ )__ /( _ )( _ )( _ )( _ )
	/ _ \|_ \/ _ \/ _ \/ _ \/ _ \
	\___/___/\___/\___/\___/\___/
		     Tom Parkes
 Copyright City Graphics Partnership
 	Last Modified - 4.4.16 (v2.1)
*************************************/

add_action('after_setup_theme','city_admin_setup');

function city_admin_setup() {

	show_admin_bar(false);

	remove_action( 'wp_head', 'wp_resource_hints', 2 );

	/* Load unregister categoires from posts */
	// function unregister_categories() {
	// 	register_taxonomy( 'category', array() );
	// }
	// add_action( 'init', 'unregister_categories' );

	add_filter( 'enable_post_by_email_configuration', '__return_false' );

	/* Disable emojis*/
	add_action( 'init', 'disable_emojis' );

	/* Load custom admin and login styles */
	add_action( 'admin_enqueue_scripts', 'city_admin_theme_style' );
	add_action( 'login_enqueue_scripts', 'city_admin_theme_style' );

	/*city footer text*/
	add_filter( 'admin_footer_text', 'remove_footer_admin' );

	/*City support link*/
	add_action( 'admin_bar_menu', 'add_support_link', 999 );

	/* admin part cleanups */
	add_action( 'admin_menu', 'remove_dashboard_widgets' ); // cleaning dashboard widgets
	add_action( 'wp_network_dashboard_setup', 'remove_dashboard_widgets' );
	add_action( 'wp_user_dashboard_setup',    'remove_dashboard_widgets' );
	add_action( 'wp_dashboard_setup',         'remove_dashboard_widgets' );
	add_action( 'admin_menu', 'delete_menu_items' ); // deleting menu items from admin area
	add_action( 'admin_menu','customize_meta_boxes' ); // remove some meta boxes from pages and posts edition page
	add_filter( 'manage_posts_columns', 'custom_post_columns' ); // remove column entries from list of posts
	add_filter( 'manage_pages_columns', 'custom_pages_columns' ); // remove column entries from list of page
	add_filter( 'manage_media_columns', 'custom_media_columns' ); // remove column entries from list of page
	add_filter( 'manage_media_columns', 'custom_media_columns' ); // remove column entries from list of page

	add_action('wp_before_admin_bar_render', 'custom_admin_bar_render' ); // clean up the admin bar
	add_action('widgets_init', 'unregister_default_widgets', 11); // remove widgets from the widget page

	add_filter( 'contextual_help', 'remove_help', 999, 3 ); // Remove help tab

	add_action('admin_notices','remove_update_notification_nonadmins',1); // remove notification for enayone but admin
	add_action('pre_ping','remove_self_pings'); // disable self-trackbacking

	add_filter( 'login_headerurl', 'custom_login_url' );// Make admin link point to the home of the site
	add_filter( 'login_headertitle', 'custom_login_title' );// Change alt title of admin logo to use blog name

	/***************** Security + header clean-ups ************************/
	add_filter( 'admin_title', 'cms_title_tag', 10, 2 );
	remove_action( 'wp_head', 'wlwmanifest_link' );
	remove_action( 'wp_head', 'rsd_link' );
	remove_action( 'wp_head', 'index_rel_link' ); // index link
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 ); // prev link
	remove_action( 'wp_head', 'start_post_rel_link', 10, 0 ); // start link
	remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0 ); // Display relational links for the posts adjacent to the current post.
	remove_action( 'wp_head', 'feed_links_extra', 3 ); // Display the links to the extra feeds such as category feeds
	remove_action( 'wp_head', 'feed_links', 2 ); // Display the links to the general feeds: Post and Comment Feed
	remove_action( 'wp_head', 'start_post_rel_link' );
	remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head' );
	remove_action( 'wp_head', 'wp_generator' ); // remove WP version from header
	remove_action( 'wp_head', 'wp_shortlink_wp_head' );
	remove_action( 'wp_head', 'rest_output_link_wp_head' );


	/***************** Login Screen cleanup ************************/
	add_filter( 'login_headerurl', 'city_login_logo_url' ); //Login logo url
	add_filter( 'login_headertitle', 'city_login_logo_url_title' ); //Login logo title

	// removes detailed login error information for security
	add_filter( 'login_errors', 'disable_wordpress_loginerrors' );

	remove_action( 'welcome_panel', 'wp_welcome_panel' );
	remove_action( 'admin_color_scheme_picker', 'admin_color_scheme_picker' );

	add_action( 'load-customize.php', 'remove_customize' );//Remove customizer
	add_action( 'admin_menu', 'remove_customize_submenu' ); // Remove appearance submenu
	add_action( 'admin_init', 'remove_editor_submenu' ); // Remove editor submenu

	/***************** User list cleanup ************************/
	add_filter( 'wpmu_users_columns', 'no_avatars_in_user_list' );
	add_action( 'restrict_manage_users', 'no_avatars_in_user_list' );
	add_action( 'manage_users_columns','remove_user_posts_column' );

	/***************** User profile cleanup ************************/
	add_action( 'admin_head-profile.php', 'profile_subject_start' );
	add_action( 'admin_footer-profile.php', 'profile_subject_end' );
	add_action( 'admin_head-profile.php', 'remove_website');
	add_action( 'personal_options', array ( 'hide_profile_description', 'start' ) );
	add_action( 'admin_head', 'hide_personal_options' );
	
	/***************** CMS mail from settings ************************/
	add_filter('wp_mail_from', 'new_mail_from');
	add_filter('wp_mail_from_name', 'new_mail_from_name');
}

// Custom admin styles
function city_admin_theme_style() {
    wp_enqueue_style('city-admin-theme', 'https://cms.838888.co.uk/css/admin.css', '1.11.1', true);
}

function disable_wordpress_loginerrors() {
	return 'Login Error';
}

// Admin footer
function remove_footer_admin () {
	echo '<span id="footer-thankyou">Created by <a href="http://www.838888.co.uk">City Graphics Partnership</a>.</span>';
}

// Change default email address
function new_mail_from($old) {
	return 'info@dyson-wine.com';
}
function new_mail_from_name($old) {
	return 'Dyson Wine';
}

// Login Logo
function city_login_logo_url() {
	return home_url();
}

function city_login_logo_url_title() {
	return 'Created by City Graphics Partnership';
}

/*** Custom link to toolbar- ----------------------------------------*/
function add_support_link( $wp_admin_bar ) {
	$args = array(
		'parent' => 'site-name',
		'id'    => 'support',
		'title' => 'Support',
		'href'  => 'mailto:tom@838888.co.uk'
	);
	$wp_admin_bar->add_node( $args );
}

/*** admin panel title tag ----------------------------------------*/
function cms_title_tag($admin_title, $title) {
    return $title .' | ' . get_bloginfo('name') . ' | CMS';
}

/*** cleaning up the dashboard- ----------------------------------------*/
function remove_dashboard_widgets(){
	remove_meta_box('dashboard_activity', 'dashboard', 'core');
	remove_meta_box('dashboard_right_now','dashboard','core'); // right now overview box
	remove_meta_box('dashboard_incoming_links','dashboard','core'); // incoming links box
	remove_meta_box('dashboard_quick_press','dashboard','core'); // quick press box
	remove_meta_box('dashboard_plugins','dashboard','core'); // new plugins box
	remove_meta_box('dashboard_recent_drafts','dashboard','core'); // recent drafts box
	remove_meta_box('dashboard_recent_comments','dashboard','core'); // recent comments box
	remove_meta_box('dashboard_primary','dashboard','core'); // wordpress development blog box
	remove_meta_box('dashboard_secondary','dashboard','core'); // other wordpress news box
	remove_meta_box('woocommerce_dashboard_recent_reviews','dashboard','core'); // other wordpress news box
	remove_meta_box( 'dashboard_primary', get_current_screen(), 'side' );
} 

/*----------------------------------------------------------------------*/

/* Remove some menus froms the admin area*/
function delete_menu_items() {
	remove_menu_page('edit.php'); // Pages
	remove_menu_page('edit-comments.php'); // Comments
	remove_menu_page('tools.php'); // Tools
	remove_menu_page( 'edit.php' );
	remove_submenu_page( 'themes.php', 'customize.php' ); // remove tags from edit
	remove_submenu_page( 'themes.php', 'theme-editor.php' ); // remove tags from edit
	remove_submenu_page('plugins.php', 'plugin-editor.php' );
	remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=post_tag' );
	remove_submenu_page('options-general.php', 'options-discussion.php' );
	remove_submenu_page('options-general.php', 'options-reading.php' );
	remove_submenu_page('options-general.php', 'options-writing.php' );
}

/*----------------------------------------------------------------------*/

function customize_meta_boxes() {
	remove_meta_box('postcustom','post','normal'); // custom fields metabox
	remove_meta_box('trackbacksdiv','post','normal'); // trackbacks metabox
	remove_meta_box('commentstatusdiv','post','normal'); // comment status metabox
	remove_meta_box('commentsdiv','post','normal'); // comments	metabox
	remove_meta_box('postexcerpt','post','normal'); // post excerpts metabox
	remove_meta_box('tagsdiv-post_tag','post','normal'); // tags
	remove_meta_box('slugdiv','post','normal'); // slug metabox
	remove_meta_box('postcustom','page','normal'); // custom fields metabox
	remove_meta_box('trackbacksdiv','page','normal'); // trackbacks metabox
	remove_meta_box('commentstatusdiv','page','normal'); // comment status metabox
	remove_meta_box('commentsdiv','page','normal'); // comments	metabox
}


function remove_customize() {
	wp_die( sprintf( __( 'No Theme Customizer support - If needed check your functions.php' ) ) . sprintf( '<br /><a href="javascript:history.go(-1);">Go back</a>' ) );
}

function remove_customize_submenu() {
	global $submenu;
	unset($submenu['themes.php'][6]);
}

function remove_editor_submenu() {
	remove_submenu_page( 'themes.php', 'theme-editor.php' );
}

/** User List ------------------------------------------*/
/** remove column avatars from users **/
function no_avatars_in_user_list( $in = NULL )
{
	add_filter( 'pre_option_show_avatars', '__return_zero' );
	return $in;
}

/** remove column posts from users **/
function remove_user_posts_column($column_headers) {
	unset($column_headers['posts']);
	return $column_headers;
}

/** Posts Lists Cleanup ------------------------------------------*/
/** remove column entries from posts **/
function custom_post_columns($defaults) {
	unset($defaults['comments']); // comments
	unset($defaults['author']); // authors
	unset($defaults['tags']); // tag
	unset($defaults['date']); // date
	return $defaults;
}

/** remove column entries from pages **/
function custom_pages_columns($defaults) {
	unset($defaults['comments']); // comments
	unset($defaults['author']); // authors
	unset($defaults['date']);	// date
	return $defaults;
}

function custom_media_columns($defaults) {
	unset($defaults['comments']); // comments 
	unset($defaults['author']); // authors
	unset($defaults['date']);	// date 
	return $defaults;
}
/*-----------------------------------------------------------------------**/


/** remove widgets from the widget page ------------------------------------*/
function unregister_default_widgets() {
	unregister_widget('WP_Widget_Pages');
	unregister_widget('WP_Widget_Calendar');
	unregister_widget('WP_Widget_Archives');
	unregister_widget('WP_Widget_Links');
	unregister_widget('WP_Widget_Meta');
	unregister_widget('WP_Widget_Search');
	unregister_widget('WP_Widget_Text');
	unregister_widget('WP_Widget_Categories');
	unregister_widget('WP_Widget_Recent_Posts');
	unregister_widget('WP_Widget_Recent_Comments');
	unregister_widget('WP_Widget_RSS');
	unregister_widget('WP_Widget_Tag_Cloud');
	unregister_widget('WP_Nav_Menu_Widget');
}


/****** removings items froms admin bars 	***********/
function custom_admin_bar_render() {
	global $wp_admin_bar;
	$wp_admin_bar->remove_menu('comments'); //remove comments
	$wp_admin_bar->remove_menu('wp-logo'); //remove the whole wordpress logo, help etc part
	$wp_admin_bar->remove_menu('new-content'); // Remove the content link
	$wp_admin_bar->remove_menu('edit-profile'); // Remove edit profile link
	$wp_admin_bar->remove_menu('view');
}

/** remove update notifications for everybody except admin users	------------------------------------*/
function remove_update_notification_nonadmins() {
	if (!current_user_can('administrator')) 
		remove_action('admin_notices','update_nag',3);
}

/** disable self-trackbacking 	------------------------------------*/
function remove_self_pings( &$links ) {
	foreach ( $links as $l => $link )
		if ( 0 === strpos( $link, home_url() ) )
			unset($links[$l]);
	}

/** Custom admin login header link	------------------------------------*/
function custom_login_url() {
	return home_url( '/' );
}

/** Custom admin login header link alt text ------------------------------------*/
function custom_login_title() {
	return get_option( 'blogname' );
}

/** Remove help tab ------------------------------------*/
function remove_help($old_help, $screen_id, $screen){
	$screen->remove_help_tabs();
	return $old_help;
}

/** Profile cleanup functions ------------------------------------*/
function remove_personal_options( $subject ) {
	$subject = preg_replace( '#<h3>Personal Options</h3>.+?/table>#s', '', $subject, 1 );
	return $subject;
}

function profile_subject_start() {
	ob_start( 'remove_personal_options' );
}

function profile_subject_end() {
	ob_end_flush();
}

function remove_website() {
	echo "<script>jQuery(document).ready(function(){jQuery('#url').parents('tr').remove();});</script>";
}

class hide_profile_description {

	public static function start() {
		$action = ( IS_PROFILE_PAGE ? 'show' : 'edit' ) . '_user_profile';
		add_action( $action, array ( __CLASS__, 'stop' ) );
		ob_start();
	}

	public static function stop() {
		$html = ob_get_contents();
		ob_end_clean();

        // remove the headline
		$headline = __( IS_PROFILE_PAGE ? 'About Yourself' : 'About the user' );
		$html = str_replace( '<h3>' . $headline . '</h3>', '', $html );

        // remove the table row
		$html = preg_replace( '~<tr>\s*<th><label for="description".*</tr>~imsUu', '', $html );
		print $html;
	}
}

function disable_emojis_tinymce( $plugins ) {
  return array_diff( $plugins, array( 'wpemoji' ) );
}

function disable_emojis() {
  remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
  remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
  remove_action( 'wp_print_styles', 'print_emoji_styles' );
  remove_action( 'admin_print_styles', 'print_emoji_styles' );  
  remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
  remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );  
  remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
  add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
}


function disable_embeds_init() {
	global $wp;
	$wp->public_query_vars = array_diff( $wp->public_query_vars, array(
		'embed',
	) );
	remove_action( 'rest_api_init', 'wp_oembed_register_route' );
	add_filter( 'embed_oembed_discover', '__return_false' );
	remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
	remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
	remove_action( 'wp_head', 'wp_oembed_add_host_js' );
	add_filter( 'tiny_mce_plugins', 'disable_embeds_tiny_mce_plugin' );
	add_filter( 'rewrite_rules_array', 'disable_embeds_rewrites' );
}
add_action( 'init', 'disable_embeds_init', 9999 );

function disable_embeds_tiny_mce_plugin( $plugins ) {
	return array_diff( $plugins, array( 'wpembed' ) );
}

function disable_embeds_rewrites( $rules ) {
	foreach ( $rules as $rule => $rewrite ) {
		if ( false !== strpos( $rewrite, 'embed=true' ) ) {
			unset( $rules[ $rule ] );
		}
	}
	return $rules;
}

function hide_personal_options() {
	echo '<script type="text/javascript">
	jQuery(document).ready(function($) {
		$(\'form#your-profile > h2:first\').hide();
		$(\'form#your-profile tr.user-rich-editing-wrap\').hide();
		$(\'form#your-profile tr.user-admin-color-wrap\').hide();
		$(\'form#your-profile tr.user-comment-shortcuts-wrap\').hide();
		$(\'form#your-profile tr.user-admin-bar-front-wrap\').hide();
		$(\'form#your-profile tr.user-language-wrap\').hide();
		$(\'.hide-if-no-customize\').hide();
		$(\'form#your-profile tr.user-nickname-wrap\').hide();
		$(\'table.form-table tr.user-display-name-wrap\').hide();
		$(\'table.form-table tr.user-url-wrap\').hide();
		$(\'form#your-profile > h2:eq(3)\').hide();
		$(\'form#your-profile tr.user-description-wrap\').hide();
		$(\'form#your-profile tr.user-profile-picture\').hide();
	});
	</script>';
}


function email_set_content_type() {
    return "text/html";
}
add_filter( 'wp_mail_content_type','email_set_content_type' );


add_action('wp_dashboard_setup', 'overview_dashboard_widget');

function overview_dashboard_widget() {
  global $wp_meta_boxes;
  wp_add_dashboard_widget('overview_widget', 'Overview', 'dashboard_overview');
}

function dashboard_overview() {
	$count_product = wp_count_posts('product');
	$count_page = wp_count_posts('page');
	echo "<p>Welcome to <strong>Dyson Wine's</strong> content management system</p>";
	echo '<p><strong>Pages:</strong> ' . $count_page->publish . ' <small><a href="/wp-admin/edit.php?post_type=page">View all</a></small><br>';
	echo '<strong>Products:</strong> ' . $count_product->publish . ' <small><a href="/wp-admin/edit.php?post_type=product">View all</a></small></p>';
	echo '<p>Need help? Contact City Graphics Partnership <a href="mailto:studio@838888.co.uk">here</a>.</p>';
}

add_action( 'admin_head', 'admin_css' );

function admin_css(){ ?>
<style>
  table.form-table tr.show-admin-bar,
  table.form-table tr.user-rich-editing-wrap,
  table.form-table tr.user-comment-shortcuts-wrap,
  #wpadminbar .quicklinks li .blavatar,
  .wp-admin #wpadminbar #wp-admin-bar-site-name>.ab-item:before,
  #wp-admin-bar-my-account>.ab-item:before,
  #wp-admin-bar-my-sites.menupop > .ab-sub-wrapper > #wp-admin-bar-my-sites-list > .menupop > .ab-sub-wrapper > ul.ab-submenu > li:nth-child(2),
  #wp-admin-bar-my-sites.menupop > .ab-sub-wrapper > #wp-admin-bar-my-sites-list > .menupop > .ab-sub-wrapper > ul.ab-submenu > li:nth-child(3) {
    display: none!important;
  }
  #your-profile tr.user-description-wrap{
    display: block!important;
  }
  #wpadminbar .quicklinks .menupop ul.ab-sub-secondary,
  #wpadminbar .quicklinks .menupop ul.ab-sub-secondary .ab-submenu {
    background: #1c7b72;
  }

  #wpadminbar #wp-admin-bar-my-sites > a.ab-item {
    line-height: 0; 
    font-size: 0;
    color: transparent; 
  }

  #wpadminbar #wp-admin-bar-my-sites>.ab-item:before {
    display: block!important;
    content: url(https://cms.838888.co.uk/img/logo_xs.png);
    width: 20px;
    height: 24px;
    margin-top: -4px;
  }

</style>
<?php
}

/*add_action( 'wp_default_scripts', function( $scripts ) {
    if ( ! empty( $scripts->registered['jquery'] ) ) {
        $scripts->registered['jquery']->deps = array_diff( $scripts->registered['jquery']->deps, array( 'jquery-migrate' ) );
    }
} );*/

//Retreive password email
add_filter("retrieve_password_message", "custom_password_reset", 99, 4);
function custom_password_reset($message, $key, $user_login, $user_data ) {
  $message = __('Someone has requested a password reset for the following account:') . "<br><br>";
  $message .= network_home_url( '/' ) . "<br><br>";
  $message .= sprintf(__('%s'), $user_data->user_email) . "<br><br>";
  $message .= __('If this was a mistake, just ignore this email and nothing will happen.') . "<br><br>";
  $message .= __('To reset your password use the link below:') . "<br><br>";
  $message .= "<a href=".network_site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user_login), 'login') .">Click here to reset your password</a><br><br>";
  $message .= "Or copy and paste this link into your browser:<br><br>" . network_site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user_login), 'login') . "<br><br>";
  return $message;
}


// Remove contributor roles
function editor_role_caps() {
    $roleObject = get_role( 'editor' );
    $roleObject->add_cap('delete_published_posts'); 
    $roleObject->add_cap('delete_posts'); 
    $roleObject->add_cap('delete_others_posts'); 
    $roleObject->add_cap('list_users');
    $roleObject->add_cap('add_users');
    $roleObject->add_cap('create_users');
    $roleObject->remove_cap('promote_users');
    $roleObject->add_cap('edit_users');
    $roleObject->remove_cap('view_all_aryo_activity_log');
    $roleObject->remove_cap('delete_users');
    if (!$roleObject->has_cap( 'edit_theme_options' ) ) {
        $roleObject->add_cap( 'edit_theme_options' );
    }
}
add_action( 'init', 'editor_role_caps' );

// Remove contributor roles
function contributor_role_caps() {
    $roleObject = get_role( 'contributor' );
    $roleObject->remove_cap('edit_posts'); 
    $roleObject->remove_cap('delete_posts');
    $roleObject->add_cap('unfiltered_html'); 
}
add_action( 'init', 'contributor_role_caps' );

if (!current_user_can( 'manage_options' )) {
    add_action('admin_head', 'custom_admin_styles');
    function custom_admin_styles() {
      echo '<style>
        .users-php ul.subsubsub {
          display: none;
        } 
      </style>';
    }
}

// Editor Menu & Move re-order Media
function editor_menu() {
    remove_menu_page('upload.php'); // Tools
    add_menu_page( 'Media', 'Media', '', 'upload.php', '', 'dashicons-admin-media', 61 );
    if(is_user_logged_in() && !current_user_can( 'manage_options' ) && current_user_can('editor')) {
        remove_menu_page('themes.php'); // Tools
        add_menu_page( 'Menus', 'Menus', 'edit_theme_options', 'nav-menus.php', '', 'dashicons-editor-justify', 65 );
    }

}
add_action('admin_menu', 'editor_menu');

class JPB_User_Caps {

  // Add our filters
  function __construct(){
    add_filter( 'editable_roles', array($this, 'editable_roles'));
    add_filter( 'map_meta_cap', array($this, 'map_meta_cap'), 10, 4);
  }

  // Remove 'Administrator' from the list of roles if the current user is not an admin
  function editable_roles( $roles ){
    if( isset( $roles['administrator'] ) && !current_user_can('administrator') ){
      unset( $roles['administrator']);
    }
    return $roles;
  }

  // If someone is trying to edit or delete and admin and that user isn't an admin, don't allow it
  function map_meta_cap( $caps, $cap, $user_id, $args ){

    switch( $cap ){
        case 'edit_user':
        case 'remove_user':
        case 'promote_user':
            if( isset($args[0]) && $args[0] == $user_id )
                break;
            elseif( !isset($args[0]) )
                $caps[] = 'do_not_allow';
            $other = new WP_User( absint($args[0]) );
            if( $other->has_cap( 'administrator' ) ){
                if(!current_user_can('administrator')){
                    $caps[] = 'do_not_allow';
                }
            }
            break;
        case 'delete_user':
        case 'delete_users':
            if( !isset($args[0]) )
                break;
            $other = new WP_User( absint($args[0]) );
            if( $other->has_cap( 'administrator' ) ){
                if(!current_user_can('administrator')){
                    $caps[] = 'do_not_allow';
                }
            }
            break;
        default:
            break;
    }
    return $caps;
  }

}

$jpb_user_caps = new JPB_User_Caps();


//Disable new user notifications
add_action( 'init', function() {
    remove_action( 'register_new_user',   'wp_send_new_user_notifications'         );
    add_action(    'register_new_user',   'wpse236122_send_new_user_notifications' );
} );

function wpse236122_send_new_user_notifications(  $user_id, $notify = 'user' ) {   
    wp_send_new_user_notifications( $user_id, $notify );    
}
?>