<?php

function vat_remove($price) {
    $gross = $price;
    $nett = $gross-($gross * (20 / 100));
    return number_format($nett, 2, '.', '');
}

function vat_amount($price) {
    $gross = $price;
    $nett = $gross-($gross * (20 / 100));
    $nett = $price - $nett;
    return number_format($nett, 2, '.', '');
}

add_filter("manage_edit-product_columns", "my_product_edit_columns");
function my_product_edit_columns($columns){
  $columns = array(
    "cb" => "<input type=\"checkbox\" />",
    "title" => "Product",
    "stock_level" => "Stock Levels",
    );
  return $columns;
}

add_action( 'manage_product_posts_custom_column', 'my_product_custom_columns', 10, 2 );
function my_product_custom_columns($column, $post_id){
  global $post;
  switch ($column) {
    case "stock_level":
    $levels = get_field('stock', $post_id);
    if ( $levels == 0 ) {
    	echo '<span style="color:red;font-weight:bold;">Out of Stock</span><br>';
    } elseif ( $levels < 12 ) {
    	echo '<span style="color:orange;font-weight:bold;">Critical</span><br>';
    } elseif ( $levels < 24 ) {
    	echo '<span style="color:#c1bf2b;font-weight:bold;">Low</span><br>';
    } elseif ( $levels < 48 ) {
    	echo '<span style="color:#4883cc;font-weight:bold;">Moderate</span><br>';
    } else {
    	echo '<span style="color:#5ca67d;font-weight:bold;">Good</span><br>';
    }
    break;
  }
}

function my_product_column_width() {
  echo '<style type="text/css">';
  echo '.column-stock_level, .column-type, .column-custom_date, .column-custom_categories { width:25% !important; overflow:hidden }';
  echo '#posts-filter .tablenav #post-query-submit { display: inline-block!important;';
  echo '</style>';
}
add_action('admin_head', 'my_product_column_width');


