<?php

$address1Err = $address2Err = $townErr = $postcodeErr = $titleErr = $firstnameErr = $lastnameErr = $telErr = "";

$company = sanitize_text_field( $_POST['company'] );
$line1 = sanitize_text_field( $_POST['line1'] );
$line2 = sanitize_text_field( $_POST['line2'] );
$line3 = sanitize_text_field( $_POST['line3'] );
$town = sanitize_text_field( $_POST['town'] );
$postcode = sanitize_text_field( $_POST['postcode'] );
$title = sanitize_text_field( $_POST['title'] );
$first_name = sanitize_text_field( $_POST['first_name'] );
$surname = sanitize_text_field( $_POST['last_name'] );
$tel = sanitize_text_field( $_POST['tel'] );
$email = sanitize_text_field( $_POST['email'] );
$prettyname = $first_name . ' ' . $surname;

if ( !empty( $company ) ) {
	if ( get_user_meta( $user_id, 'company', true ) ) {
		update_user_meta( $user_id, 'company', $company);
	} else {
		add_user_meta( $user_id, 'company', $company);
	}
} 

if ( !empty( $line1 ) ) {
	if ( get_user_meta( $user_id, 'billing_address_1', true ) ) {
		update_user_meta( $user_id, 'billing_address_1', $line1);
	} else {
		add_user_meta( $user_id, 'billing_address_1', $line1);
	}
} else {
	$address1Err = "Address line 1 required";
}

if ( !empty( $line2 ) ) {
	if ( get_user_meta( $user_id, 'billing_address_2', true ) ) {
		update_user_meta( $user_id, 'billing_address_2', $line2);
	} else {
		add_user_meta( $user_id, 'billing_address_2', $line2);
	}
} else {
	$address2Err = "Address line 2 required";
}

if ( !empty( $line3 ) ) {
	if ( get_user_meta( $user_id, 'billing_address_3', true ) ) {
		update_user_meta( $user_id, 'billing_address_3', $line3);
	} else {
		add_user_meta( $user_id, 'billing_address_3', $line3);
	}
}

if ( !empty( $town ) ) {
	if ( get_user_meta( $user_id, 'billing_town', true ) ) {
		update_user_meta( $user_id, 'billing_town', $town);
	} else {
		add_user_meta( $user_id, 'billing_town', $town);
	}
} else {
	$townErr = "Town required";
}

if ( !empty( $postcode ) ) {
	if ( get_user_meta( $user_id, 'billing_postcode', true ) ) {
		update_user_meta( $user_id, 'billing_postcode', $postcode);
	} else {
		add_user_meta( $user_id, 'billing_postcode', $postcode);
	}
} else {
	$postcodeErr = "Postcode required";
}

if ( !empty( $title ) ) {
	if ( get_user_meta( $user_id, 'title', true ) ) {
		update_user_meta( $user_id, 'title', $title);
	} else {
		add_user_meta( $user_id, 'title', $title);
	}
} else {
	$titleErr = "Title required";
}

if ( !empty( $first_name ) ) {
	$user_firstname = get_user_meta( $user_id, 'last_name', true);
	if ( !empty( $user_firstname ) ) {
		update_user_meta( $user_id, 'first_name', $first_name);
	} else {
		add_user_meta( $user_id, 'first_name', $first_name);
	}
} else {
	$firstnameErr = "First Name required";
}

if ( !empty( $surname ) ) {
	$user_lastname = get_user_meta( $user_id, 'last_name', true);
	if ( !empty( $user_lastname ) ) {
		update_user_meta( $user_id, 'last_name', $surname);
	} else {
		add_user_meta( $user_id, 'last_name', $surname);
	}
} else {
	$lastnameErr = "Surname required";
}

if ( !empty( $tel ) ) {
	if ( get_user_meta( $user_id, 'telephone_number', true ) ) {
		update_user_meta( $user_id, 'telephone_number', $tel);
	} else {
		add_user_meta( $user_id, 'telephone_number', $tel);
	}
} else {
	$telErr = "Telephone required";
}

if ( !empty( $email ) && is_email( $email ) ) {
	$current_user = wp_get_current_user();
	if ( $current_user->user_email != $email ) {
		wp_update_user( array( 'ID' => $user_id, 'user_email' => $email ) );
	}
} else {
	$emailErr = "Email required";
}


//Check all required fields have data
if ( empty($address1Err) && empty($address2Err) && empty($townErr) && empty($postcodeErr) && empty($titleErr) && empty($firstnameErr) && empty($lastnameErr) && empty($telErr) && empty($emailErr) ) {
	wp_redirect('account'); exit();
}