<?php
if ( !isset($_SESSION["basket"]['order']) ) {

	$order_details = array(
	  'post_status'		=> 'publish',
	  'post_author'		=> $user_id,
	  'post_type'		=> 'orders'
	);
	//Create order
	$order = wp_insert_post( $order_details );

	//Update post title to order ID
	$order = wp_update_post( array(
	  'ID'           => $order,
	  'post_title'   => '#'.$order,
	) );

	//Update the user sessions with order ID
	$_SESSION["basket"]['order'] = array( 'order_id' => $order, 'order_user' => $user_id);
	$user_ip = $_SERVER['REMOTE_ADDR'];

	//Set order user id and email
	update_post_meta( $order, 'order_user', $user_id );
	update_post_meta( $order, 'order_ip', $user_ip );

	//Set order items
	$items = $_SESSION['basket']['items'];
	$i = 0;
	foreach ($items as $item) {
		$product = $item['product'];
		$variation = $item['variation'];
		$quantity = $item['quantity'];
		$item_price = get_item_price( $product, $variation );
		$total = $item_price * $quantity;
		update_post_meta( $order, 'items_'.$i.'_product', $product );
		update_post_meta( $order, '_items_'.$i.'_product', 'field_5b180a0df52bc' );
		update_post_meta( $order, 'items_'.$i.'_variation', $variation );
		update_post_meta( $order, '_items_'.$i.'_variation', 'field_5b193fef9873b' );
		update_post_meta( $order, 'items_'.$i.'_quantity', $quantity );
		update_post_meta( $order, '_items_'.$i.'_quantity', 'field_5b180a11f52bd' );
		update_post_meta( $order, 'items_'.$i.'_cost', number_format( (float)$total, 2 ) );
		update_post_meta( $order, '_items_'.$i.'_cost', 'field_5b193e6e3b25f' );
	$i++; }
	update_post_meta( $order, 'items', count($items) );
	update_post_meta( $order, '_items', 'field_5b180a05f52bb' );
	//Set order delivery info
	$delivery_cost = delivery_total_cost();
	update_post_meta( $order, 'delivery_cost', $delivery_cost );
	update_post_meta( $order, '_delivery_cost', 'field_5b180b166e8f2' );
	//set order total cost
	$items_subtotal = basket_cost();
	update_post_meta( $order, 'items_subtotal', $items_subtotal );
	update_post_meta( $order, '_items_subtotal', 'field_5b180ae20674a' );
    //set order total cost
    update_post_meta( $order, 'total', $items_subtotal + $delivery_cost );
    update_post_meta( $order, '_total', 'field_5b194878d6f04' );
        
	//Set order status
	update_post_meta( $order, 'order_status', '0' );
	if ( !empty( $_SESSION["basket"]['voucher']['id'] ) ) {
		$voucher = $_SESSION["basket"]['voucher']['id'];
		update_post_meta( $order, 'order_voucher', $voucher);
	}
}