<?php
$columns = get_sub_field('columns');
$title = get_sub_field('title');
$subtitle = get_sub_field('subtitle');
$content = get_sub_field('content');
$showLink = get_sub_field("show_link");
$link = get_sub_field("link");
$linkTitle = get_sub_field("link_title");
$background = get_sub_field("background");
$background_colour = get_sub_field("background_colour");
$background_split = get_sub_field("background_split");
$padding = get_sub_field('padding');
$c = count($columns);
?>

<div class="<?php if ( $background_split ) { echo 'bg-split '; } ?>bg-cover bg-<?php echo $background_colour; ?> pd-v-<?php echo $padding; ?>"<?php if ( $background ) { ?> style="background-image: url('<?php echo $background["sizes"]["fullsize"]; ?>');"<?php } ?>>
<?php if ( $title || $content ) { ?>

		<div class="container container-xnarrow text-center">

			<?php if ( $title ) { ?>

			<h2><?php echo $title; ?></h2>
			<?php } ?>

			<?php if ( $content ) { ?>

			<div class="content"><?php echo $content; ?></div>
			<?php } ?>

		</div>
<?php } ?>

<?php if ( $columns ) { ?>

		<div class="container">

			<ul class="<?php if ( $c > 4 ) { echo 'grid-col-3'; } else { echo 'grid-col-' . $c; } ?>">
				<?php foreach ($columns as $column) { ?>
				<?php
				$columnImage = $column['image'];
				$columnIcon = $column['icon'];
				$columnTitle = $column['title'];
				$columnSubTitle = $column['sub_title'];
				$columnLink = $column['link'];
				$columnLinkTitle = $column['link_title'];
				$columnContent = $column['content'];
				$columnAlign = $column['text_align'];
				?>

				<li class="content <?php echo $columnAlign; ?>">

					<div class="pd-v-md pd-h-lg">
						<?php if ( $columnIcon ) { ?>

						<div class="space-2">

							<div class="icon-wrap">

								<img src="<?php echo $columnIcon["sizes"]["small-1x1"]; ?>" alt="<?php echo $columnIcon["title"]; ?>" class="img-responsive" />

							</div>

						</div>
						<?php } ?>
						<?php if ( $columnImage ) { ?>
						<?php if ( !$columnTitle ) { ?>

						<img src="<?php echo $columnImage["sizes"]["small-4x3"]; ?>" alt="<?php echo $columnImage["title"]; ?>" class="img-responsive" />
						<?php } else { ?>

						<img src="<?php echo $columnImage["sizes"]["small-1x1"]; ?>" alt="<?php echo $columnImage["title"]; ?>" class="img-responsive" />
						<?php } ?>
						<?php } ?>
						<?php if ( !$columnIcon && !$columnImage ) { ?>

						<div class="pd-v-md">
						<?php } ?>
						<?php if ( $columnTitle ) { ?>

						<h2 class="space-1"><?php echo $columnTitle; ?></h2>
						<?php } ?>
						<?php if ( $columnSubTitle ) { ?>

						<h3 class="space-1"><?php echo $columnSubTitle; ?></h3>
						<?php } ?>
						<?php if ( $columnContent ) { ?>

						<div class="space-1"><?php echo $columnContent; ?></div>
						<?php } ?>
						<?php if ( $columnLink ) { ?>

						<a href="<?php echo $columnLink; ?>" title="<?php echo $columnTitle; ?>" class="btn btn-primary btn-more"><?php echo $columnLinkTitle; ?></a>
						<?php } ?>
						<?php if ( !$columnIcon && !$columnImage ) { ?>
								
						</div>
						<?php } ?>

					</div>

				</li>

				<?php } ?>
			</ul>

		</div>
<?php } ?>

<?php if ( $subtitle ) { ?>

<div class="container container-narrow text-center space-2 space-2-sm"><h4 class="text-heading text-uppercase sc-reveal"><?php echo $subtitle; ?></h4></div>
<?php } ?>

<?php if ( $showLink && $link && $linkTitle ) { ?>

<div class="container text-center sc-reveal"><a href="<?php echo $link; ?>" class="btn btn-secondary" title="<?php echo $linkTitle; ?>"><?php echo $linkTitle; ?></a></div>
<?php } ?>


</div>