<?php
add_action( 'init', 'register_cpt_order' );
add_action( 'init', 'register_cpt_product' );
add_action( 'init', 'register_cpt_voucher' );
add_action( 'init', 'register_cpt_vineyard' );
add_action( 'init', 'register_tax_type' );

//Register 'product' custom post type
function register_cpt_product() {
    $labels = array( 
        'name'               => __( 'Product' ),
        'singular_name'      => __( 'Product' ),
        'add_new'            => __( 'Add New Product' ),
        'add_new_item'       => __( 'Add New Product' ),
        'edit_item'          => __( 'Edit Product' ),
        'new_item'           => __( 'New Products' ),
        'view_item'          => __( 'View products' ),
        'search_items'       => __( 'Search products' ),
        'not_found'          => __( 'No products found' ),
        'not_found_in_trash' => __( 'No products found in Trash' ),
        'parent_item_colon'  => __( 'Parent Product:' ),
        'menu_name'          => __( 'Products' ),
    );
    $args = array( 
        'labels'                => $labels,
        'hierarchical'          => false,
        'public'                => true,
        'show_in_menu'          => true,
        'rewrite'               => array( 'slug' => 'wine', 'with_front' => false ),
        'menu_position'         => 5,
        'capability_type'       => 'post',
        'show_ui'               => true,
        'menu_icon'             => 'dashicons-cart',
        'supports'              =>  array( 'title' ),
    );
    register_post_type( 'product', $args );
}

//Register 'order' custom post type
function register_cpt_order() {
    $labels = array( 
        'name'               => __( 'Orders' ),
        'singular_name'      => __( 'Orders' ),
        'add_new'            => __( 'Add New Order' ),
        'add_new_item'       => __( 'Add New Order' ),
        'edit_item'          => __( 'Edit Order' ),
        'new_item'           => __( 'New Order' ),
        'view_item'          => __( 'View Order' ),
        'search_items'       => __( 'Search Orders' ),
        'not_found'          => __( 'No orders found' ),
        'not_found_in_trash' => __( 'No orders found in Trash' ),
        'parent_item_colon'  => __( 'Parent order:' ),
        'menu_name'          => __( 'Orders' ),
        );
    $args = array( 
        'labels'                => $labels,
        'hierarchical'          => false,
        'public'                => true,
        'publicly_queryable'    => true,
        'show_in_menu'          => true,
        'menu_position'         => 3,
        'exclude_from_search'   => true,
        'show_in_nav_menus'     => false,
        'has_archive'           => false,
        'rewrite'               => false,
        'show_ui'               => true,
        'menu_icon'             => 'dashicons-clipboard',
        'supports'            => array( 
            'title', 'author'
            ),
        );
    register_post_type( 'orders', $args );
}

//Register 'vouchers' custom post type
function register_cpt_voucher() {
    $labels = array( 
        'name'               => __( 'Vouchers' ),
        'singular_name'      => __( 'Voucher' ),
        'add_new'            => __( 'Add New Voucher' ),
        'add_new_item'       => __( 'Add New Voucher' ),
        'edit_item'          => __( 'Edit Voucher' ),
        'new_item'           => __( 'New Voucher' ),
        'view_item'          => __( 'View Voucher' ),
        'search_items'       => __( 'Search Vouchers' ),
        'not_found'          => __( 'No vouchers found' ),
        'not_found_in_trash' => __( 'No vouchers found in Trash' ),
        'parent_item_colon'  => __( 'Parent voucher:' ),
        'menu_name'          => __( 'Vouchers' ),
    );
    $args = array( 
        'labels'              => $labels,
        'hierarchical'        => false,
        'public'              => false,
        'publicly_queryable'  => true,
        'show_in_menu'        => true,
        'menu_position'       => 5,
        'exclude_from_search' => true,
        'show_in_nav_menus'   => false,
        'has_archive'         => false,
        'rewrite'             => false,
        'show_ui'             => true,
        'menu_icon'           => 'dashicons-tag',
        'supports'            => array( 'title' ),
    );
    register_post_type( 'voucher', $args );
}

//Register 'vineyard' custom post type
function register_cpt_vineyard() {
    $labels = array( 
        'name'               => __( 'Vineyard' ),
        'singular_name'      => __( 'Vineyard' ),
        'add_new'            => __( 'Add New Section' ),
        'add_new_item'       => __( 'Add New Section' ),
        'edit_item'          => __( 'Edit Section' ),
        'new_item'           => __( 'New Section' ),
        'view_item'          => __( 'View Section' ),
        'search_items'       => __( 'Search Sections' ),
        'not_found'          => __( 'No vouchers found' ),
        'not_found_in_trash' => __( 'No vouchers found in Trash' ),
        'parent_item_colon'  => __( 'Parent voucher:' ),
        'menu_name'          => __( 'Vineyard' ),
    );
    $args = array( 
        'labels'              => $labels,
        'hierarchical'        => false,
        'public'              => false,
        'publicly_queryable'  => true,
        'show_in_menu'        => true,
        'menu_position'       => 5,
        'exclude_from_search' => true,
        'show_in_nav_menus'   => false,
        'has_archive'         => false,
        'rewrite'             => false,
        'show_ui'             => true,
        'menu_icon'           => 'dashicons-awards',
        'supports'            => array( 'title' ),
    );
    register_post_type( 'vineyard', $args );
}

//Register 'type' taxonomy for products
function register_tax_type() {
   register_taxonomy(
        'type',
        array( 'product' ),
        array(
            'labels' => array(
                'name'          => 'Type',
                'singular_name' => 'Type',
                'add_new_item'  => 'Add New Type'
            ),
            'show_ui'               =>  true,
            'hierarchical'          =>  true,
            'show_admin_column'     =>  true,
            'query_var'             =>  true,
            'show_in_quick_edit'    =>  true,
            'rewrite' => array( 'slug' => 'type', 'with_front' => true )
        )
    );
}