		<?php
		$images = get_field('images');
		$description = get_field('description');
		$delivery = get_field('delivery');
		$type = get_field('type');
		if ( !$delivery ) {
			$delivery = get_post(266);
			$delivery = $delivery->post_content;
			$delivery = apply_filters('the_content', $delivery);
			$delivery = str_replace(']]>', ']]&gt;', $delivery);
		}
		$content = apply_filters('the_content', get_post_field('post_content', $post->ID));
		$variations = get_field('variations');
		$frameoptions = get_field('options');
		$hasVariations = get_field('has_variations');
		$sold = get_field('sold');
		$terms = get_the_terms( $post->ID, 'type' );
		if ( $terms ) {
			$term = array_pop($terms);
		}
		$selectedVariation = null;
		$selectedOption = null;
		if ( $variations ) {
			if ( isset($variations[0]['title']) ) {
				$selectedVariation = slugify( $variations[0]['title'] );
			}
			if ( isset($variations[0]['options'][0]['title']) ) {
				$selectedOption = slugify( $variations[0]['options'][0]['title'] );
			}
		}
		if ( get_query_var('variation') ) {
			$selectedVariation = get_query_var('variation');
		}
		if ( get_query_var('option') ) {
			$selectedOption = get_query_var('option');
		}
		if ( isset($_GET['variation']) ) {
			$selectedVariation = $_GET['variation'];
		}
		if ( isset($_GET['option']) ) {
			$selectedOption = $_GET['option'];
		} ?>
		
		<div class="pd-v-lg bg-light">

			<div class="pd-v-lg"></div>

			<div class="container">
					<?php //First get the selected variation
					if ( $variations ) {
						$i = 0;
						$selectedVariationID = 0;
						foreach( $variations as $variation ) {
							$title = slugify( $variation['title'] ); 
							if ( $selectedVariation == $title ) {
								$selectedVariationID = $i;
								break;
							} $i++;
						} ?>
					<?php //Then get the selected colour if options
					if ( $options = $variations[$selectedVariationID]['options'] ) {
						if ( !empty($options) ) {
							$c = 0;
							foreach($options as $option) {
								$optionSlug = slugify( $option['title'] );
								$selectedOptionID = 0;
								if ( $selectedOption == $optionSlug ) {
									$selectedOptionID = $c;
									break;
								} $c++;
							} 
						}
					} //end if options ?>
					<?php } ?>
					<?php if ( isset($images) && !empty($images) ) { ?>

					<div class="col-6 col-12-sm space-2-sm pd-h-md product-images loading">

						<div class="container product-images-full">

							<div class="slider">

								<ul class="slides">
									<?php foreach ($images as $image) { ?>

									<li>

										<a href="<?php echo $image['sizes']['fullsize']; ?>" class="img-lightbox">

											<img src="<?php echo $image['sizes']['medium-4x3']; ?>" class="img-responsive">

										</a>

									</li>
									<?php } ?>

								</ul>

							</div>

						</div>
						<?php if ( count($images) > 1 ) { ?>

						<div class="container product-images-thumbnails">

							<div class="slider">

								<ul class="slides">
									<?php foreach ($images as $image) { ?>

									<li>

										<img src="<?php echo $image['sizes']['small-1x1']; ?>" class="img-responsive">

									</li>
									<?php } ?>

								</ul>

							</div>

						</div>
						<?php } ?>

					</div>
					<?php } else { ?>

					<div class="col-6 col-12-sm space-2-sm pd-h-md">

						<img src="<?php echo site_url('img/default.jpg'); ?>" class="img-responsive">

					</div>


					<?php } ?>

				<div class="col-6 col-12-sm pd-h-md">

					<h1 class="h2 text-bold space-1"><?php the_title(); ?></h1>
				<?php if ( $content ) { ?>

					<div class="space-2"><?php echo $content; ?></div>
				<?php } ?>

				<?php if ( !$sold ) { ?>
					<form action="<?php the_permalink(); ?>" method="post" class="standard_form add-to-basket-form form-product">

					<?php if ( !empty($variations) && !empty($hasVariations) ) { ?>

						<?php $c = 0; foreach($variations as $variation) { ?>

						<input type="hidden" name="variation" value="<?php echo $c; ?>" />

						<div class="form-row space-2">

							<div class="container space-1"><label for="<?php echo slugify( $variation['title'] ); ?>"><?php echo $variation['title']; ?></label></div>
							<?php if ( $variation['options'] ) { ?>

								<?php $i = 0; foreach ( $variation['options'] as $option ) { ?>
							
									<input type="radio" class="variant-radio-button required" name="option" id="variation-<?php echo $c; ?>-option-<?php echo $i; ?>" value="<?php echo $i; ?>" data-slug="<?php echo slugify($option['title']); ?>" data-price="<?php echo $option['price']; ?>"<?php if ( $selectedOption == slugify($option['title']) || $i == 0 ) { echo ' checked'; } ?>>

									<label for="variation-<?php echo $c; ?>-option-<?php echo $i; ?>" class="variant-radio-button-label"><?php echo $option['title']; ?></label>
								<?php $i++; } ?>

							<?php } ?>

						</div>
						<?php $c++; } ?>

						<?php } ?>

						<div class="form-row row-price space-2">

							<strong class="text-heavy text-price h3">£<span class="variation-price"><?php $price = get_field('price'); if ( $price && empty($hasVariations) ) { echo number_format($price,2); } else { echo '0'; } ?></span></strong>&nbsp; inc. VAT

						</div>

						<div class="form-row space-2">

							<?php if ( !empty($hasVariations) ) { ?>

								<div class="qty-wrap">

									<input type="number" name="quantity" class="input qty" value="1" min="1" />

									<input type='button' value='-' class='qtyminus' field='quantity' />

									<input type='button' value='+' class='qtyplus' field='quantity' />

								</div>

							<?php } else { ?>

								<input type="hidden" name="quantity" value="1" />

							<?php } ?>

							<input type="hidden" name="product" value="<?php echo $post->ID; ?>" />

							<button type="submit" class="btn btn-primary submit">Add to Bag</button>

						</div>

						<div class="add-to-basket-msg"></div>

					</form>
					<?php } else { ?>

					<p class="space-1"><strong class="text-heavy text-highlight text-price">Sold Out</strong></p>
					<?php } ?>

					<ul class="tabs-nav">
						<?php if ( $description ) { ?>
					
						<li class="tab-active">

							<a href="#description" rel="nofollow">Description</a>
					
						</li>
						<?php } ?>
					
						<li>

							<a href="#delivery" rel="nofollow">Delivery</a>
						
						</li>
					
					</ul>
					
					<div class="tabs-stage">
						<?php if ( $description ) { ?>

						<div id="description" class="content">

							<?php echo $description; ?>
						
						</div>
						<?php } ?>

						<div id="delivery" class="content">

							<?php echo $delivery; ?>
						
						</div>

					</div>

				</div>

			</div>

		</div>