<?php
if ( is_front_page() ) {
	//$id = 1;
	$id = get_the_ID();
} else if (is_shop()) {
	$id = get_option( 'woocommerce_shop_page_id' ); 
} else {
	$id = get_the_ID();
} ?>
<?php
$type = get_field('hero_type', $id);
$slides = get_field('slides', $id);
$height = get_field('height', $id);
if ( !$height ) {
	$height = 'hero';
}
$mp4 = get_field('mp4', $id);
$webm = get_field('webm', $id);
$ogv = get_field('ogv', $id);
$image = get_field('image', $id);
$caption = get_field('caption', $id);
if ( $type == 'video' && $mp4 && $webm && $ogv ) { ?>

<div class="<?php echo $height; ?>">

	<video autoplay loop muted playsinline preload<?php if ( $image ) { echo ' poster="' . $image['sizes']['hero'] . '"'; } ?> class="va-container" id="hero-video">

		<source src="<?php echo $webm; ?>" type="video/webm">

		<source src="<?php echo $ogv; ?>" type="video/ogg">

		<source src="<?php echo $mp4; ?>" type="video/mp4">

	</video>
	<?php if ( $caption ) { ?>

	<div class="alpha bg-alpha"></div>

	<div class="va-container">

		<div class="va-content">

			<div class="va-text v-align-middle text-center">

				<div class="caption text-contrast">

					<?php echo $caption; ?>

				</div>

			</div>

		</div>

	</div>
	<?php } ?>

</div>
<?php } elseif ( !empty($slides) ) { ?>

<div class="<?php echo $height; ?> loading" id="hero-slider">

	<div class="va-container">

		<div class="slider">

			<ul class="slides">
				<?php foreach ($slides as $slide) { ?>
				<?php if ( isset($slide["image"] ) ) { ?>
				<?php
				$subtitle = $slide["sub_title"];
				$title = $slide["title"];
				$content = $slide["content"];
				$showLink = $slide["show_link"];
				$link = $slide["link"];
				$linkTitle = $slide["link_title"];
				$image = $slide["image"];
				$overlay = $slide["overlay"];
				$align = $slide["align"];
				if ( $align == 'right' ) {
					$cols = 'shift-col-7 shift-col-6-md shift-col-5-sm';
				} elseif ( $align == 'centre' ) {
					$cols = 'col-12 text-center';
				} else {
					$cols = 'col-10 col-10-sm';
				}
				?>

				<li class="bg-cover" style="background-image: url('<?php echo $image["sizes"]["hero"]; ?>');">
					<?php if ( $overlay ) { ?>

					<div class="alpha bg-alpha"></div>
					<?php } ?>

					<div class="va-container">

						<div class="va-content">

							<div class="va-text v-align-middle">

								<div class="container">

									<div class="caption text-contrast <?php echo $cols; ?>">	
										<?php if ( $subtitle ) { ?>

										<h4 class="text-light text-spaced text-uppercase"><?php echo $subtitle; ?></h4>
										<?php } ?><?php if ( $title ) { ?>

										<h1 class="text-heading text-jumbo space-1"><?php echo $title; ?></h1>
										<?php } ?><?php if ( $content ) { ?>

										<p class="space-2 space-1-sm text-bold"><?php echo $content; ?></p>
										<?php } ?><?php if ( $showLink && $link && $linkTitle ) { ?>

										<a href="<?php echo $link; ?>" class="btn btn-outline-light" title="<?php echo $linkTitle; ?>"><?php echo $linkTitle; ?></a>
										<?php } ?>

									</div>

								</div>

							</div>

						</div>

					</div>

				</li><?php } ?>
				<?php } ?> 

			</ul>

		</div>

	</div>

</div>
<?php } ?>