<?php
$slides = get_sub_field('slides');
?>
<?php if ( !empty($slides) ) { ?>

	<div class="content-slides slider loading">

		<ul class="slides">
			<?php foreach ($slides as $slide) { ?>
				<?php
				$image = $slide["image"]; 
				$title = $slide["title"]; 
				$content = $slide["content"];
				$showLink = $slide["show_link"];
				$linkTitle = $slide["link_title"];
				$linkUrl = $slide["link"];
				$invert = $slide["invert_text"];
				?>

				<li class="bg-cover<?php if ( $invert ) { echo ' text-contrast'; } ?>"<?php if ( $image ) { ?> style="background-image: url('<?php echo $image["sizes"]["hero"]; ?>');"<?php } ?>>

					<div class="container">

						<div class="col-6 col-10-sm">

							<div class="caption pd-v-xxl">
								<?php if ( $title ) { ?>

								<h3 class="h2 space-2"><?php echo $title; ?></h3>
								<?php } ?>
								<?php if ( $content ) { ?>

								<div class="space-2"><?php echo $content; ?></div>
								<?php } ?>
								<?php if ( $showLink && $linkTitle && $linkUrl ) { ?>

								<a href="<?php echo $linkUrl; ?>" class="btn btn-outline<?php if ( $invert ) { echo ' btn-outline-light'; } ?>"><?php echo $linkTitle; ?></a>
								<?php } ?>

							</div>

						</div>

					</div>

				</li>
			<?php } ?> 

			</ul>

		</div>
<?php } ?>