<?php
if ( !empty( $_POST["voucher_code"] ) && !isset( $_SESSION["basket"]['voucher']['id'] ) ) {
	$voucher_code = sanitize_text_field($_POST["voucher_code"]);
	//error_log('Voucher Code Entered:'.$voucher_code);
	$args = array(
		'post_type' => 'voucher',
		'meta_query' 	=> array(
			'relation' 		=> 'AND',
			array(
				'key' 		=> 		'voucher_code',
				'value'		=> 		$voucher_code,
				'compare' 	=> 		'LIKE',
			),
			array(
				'relation' => 'OR',
				array(
					'relation' => 'OR',
					array(
						'key' 		=> 		'expiry_date',
						'value' 	=> 		date("Ymd"),
						'compare' 	=> 		'>=',
						'type' 		=> 		'NUMERIC'
					),
					array(
						'key' 		=> 		'expiry_date',
						'value' 	=> 		'',
						'compare' 	=> 		'EXISTS'
					),
				),
				array(
					'key' 		=> 		'expiry_date',
					'value' 	=> 		'',
					'compare' 	=> 		'NOT EXISTS'
				),
			)
		)
	);
	$vouchers = get_posts( $args );
	//If posts found
	if ( !empty($vouchers) ) {
		error_log('Voucher Found');
		$_SESSION["basket"]['voucher']['id'] = $vouchers[0]->ID;
		echo '<div class="alert alert-success"><strong>Success!</strong> voucher ' . $vouchers[0]->post_title . ' applied</div>';
	} else {
		echo '<div class="alert alert-message"><strong>Error!</strong> Voucher not found</div>';
	}

} elseif ( !empty( $_POST["remove-voucher"] ) && isset( $_SESSION["basket"]['voucher']['id'] ) ) {

	unset( $_SESSION["basket"]['voucher']['id'] );

	if ( isset($_SESSION["basket"]['order']['order_id']) && get_post_meta( $order, 'order_voucher' ) ) {
		$order = $_SESSION["basket"]['order']['order_id'];
		delete_post_meta( $order, 'order_voucher' );
	}

}

?>
