<?php

if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'log-in' && wp_verify_nonce($_POST['login_nonce_field'],'verify_true_login') && ($_POST['formName'] == 'login') ){
	if ( isset( $_POST['remember-me'] ) )
		$remember = true;
	else {
		$remember = false;
	}

	$creds = array();
	$creds['user_login'] = $_POST['user_email'];
	$creds['user_password'] = $_POST['user_password'];
	$creds['remember'] = $remember;
	$user = wp_signon( $creds, false );
	if ( is_wp_error($user) ) {

		$loginErr = $user->get_error_message();

	} elseif ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) {

		wp_redirect('checkout?step=1');
		exit();

	} else {

		wp_redirect('account');
		exit();

	}
}


if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'guest' && wp_verify_nonce($_POST['guest_nonce_field'],'verify_true_guest') && ($_POST['formName'] == 'guest') ){

	$email = sanitize_email( $_POST['guest_email'] );

	if( !is_email($email)) {
		$guestErr = "Invalid Email";
	}

	if( email_exists( $email ) ) {
		$guestErr = "Email address entered already exists, please sign in.";
	}

	if ( !isset( $_POST['terms'] ) ) {
		$guestErr = 'Please confirm you accept our <a href="' . site_url() . '/privacy/" target="_blank">privacy policy</a> and <a href="' . site_url() . '/terms/" target="_blank">terms &amp; conditions</a>';
	}

	if (empty($guestErr)) {

		$username = rand(10000,90000);
		$password = rand(10000,90000);
		$hash = wp_hash_password( $password );

		$userdata = array(
			'user_login'  =>  $username,
			'user_email'  =>  $email,
			'user_pass'   =>  $password
			);

		$new_user_id = wp_insert_user( $userdata ) ;

		if($new_user_id) {

			if ( isset($_POST['marketing']) ) {
				add_user_meta( $new_user_id, 'no-marketing', 1);
			}
			add_user_meta( $new_user_id, 'guest', 1);

			$user = wp_signon( array( 'user_login' => get_user_by('email', $email) -> user_login, 'user_password' => $password, false ));

			if ( is_wp_error($user) ) {

				$guestErr = $user->get_error_message();

			} elseif ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) {

				wp_redirect('checkout?step=1');
				exit(); 

			} else {

				wp_redirect('account');
				exit();

			}
		}
	}
}

if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'register' && wp_verify_nonce($_POST['register_nonce_field'],'verify_true_register') && ($_POST['formName'] == 'register') ){

	$email = sanitize_email( $_POST['user_email'] );
	$password = $_POST['password'];
	$vpassword = $_POST['verify_password'];
	$first_name = sanitize_text_field( $_POST['first_name'] );
	$last_name = sanitize_text_field( $_POST['last_name'] );


	if( !is_email($email)) {
		$regErr = "Invalid Email";
	}

	if( email_exists( $email ) ) {
		$regErr = "Email address entered already exists, please sign in.";
	}

	if ( !isset($_POST['terms']) ) {
		$regErr = 'Please confirm you accept our <a href="' . site_url() . '/privacy/" target="_blank">privacy policy</a> and <a href="' . site_url() . '/terms/" target="_blank">terms &amp; conditions</a>';
	}

	if ( !isset($_POST['age']) ) {
		$regErr = 'Please confirm you are over 18 years of age';
	}

	if( $password == '') {
		$regErr = "Passwords dont match";
	}
	if ( $password !== $vpassword ) {
		$regErr = "Passwords dont match";
	}
	if ( strlen($password) < 6 ) {
		$regErr = 'Please make sure your password is at least 6 characters long';
	} 

	if ( empty($regErr) ) {

		$username = rand(10000,90000);
		$display = $first_name . ' ' . $last_name;

		$hash = wp_hash_password( $password );
		
		$userdata = array(
			'user_login'  =>  $username,
			'user_email'  =>  $email,
			'user_pass'   =>  $password,
			'display_name'   =>  $display,
			'first_name'   =>  $first_name,
			'last_name'   =>  $last_name,
			);

		$new_user_id = wp_insert_user( $userdata ) ;

		if($new_user_id) {

			wp_new_user_notification($new_user_id);

			if ( isset($_POST['marketing']) ) {
				add_user_meta( $new_user_id, 'no-marketing', 1);
			}

			$user = wp_signon( array( 'user_login' => get_user_by('email', $email) -> user_login, 'user_password' => $password, false ));

			if ( is_wp_error($user) ) {

				$regErr = $user->get_error_message();

			} elseif ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) {

				wp_redirect('checkout?step=1');
				exit(); 

			} else {

				wp_redirect('account');
				exit();

			}
		}
	}
}
?>
<?php get_header(); ?>

<div class="pd-v-lg bg-light">

	<div class="container pd-v-sm text-center space-2">

		<h2 class="text-heading text-heavy"><?php the_title(); ?></h2>

	</div>

	<div class="container">
		<div class="col-6 col-12-sm pd-h-md">
			<div class="form-wrapper space-1">
				<header class="subhead subhead_dropdown<?php if ( !isset($regErr) ) { ?> active<?php } ?>">
					<a href="#">
						<h3 class="space-1">Returning Customer</h3>
						<p>Sign in using your email address and password.</p>
					</a>
				</header>
				<form id="loginForm" class="standard_form reveal" action="" method="POST"<?php if ( !isset($regErr) ) { ?> style="display: block;"<?php } ?>>
					<?php if ( isset($loginErr) ) { ?>
						<div class="alert alert-error"><?php echo $loginErr; ?></div>
					<?php } ?>
					<div class="row space-1">
						<label for="email"><?php _e('Email'); ?></label>
						<input name="user_email" id="email" class="input required" type="email" />
					</div>
					<div class="row space-1">
						<label for="password"><?php _e('Password'); ?></label>
						<input name="user_password" id="password" class="input required" type="password" />
					</div>
					<div class="row space-1">
						<input class="remember-me checkbox" name="remember-me" id="remember-me" type="checkbox" checked="checked" value="forever" />
						<label for="remember-me">Remember me</label>
					</div>
					<!--<p>
						<a href="<?php echo wp_lostpassword_url( get_bloginfo('url') ); ?>">Forgotten password?</a>
					</p> -->
					<div class="form-row">
						<input type="hidden" name="action" value="log-in" />
						<input type="hidden" name="formName" value="login" />
						<input type="hidden" name="login_nonce_field" value="<?php echo wp_create_nonce('verify_true_login'); ?>"/>
						<input type="submit" class="btn btn-primary btn-block" value="<?php if ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) { echo 'Log In & Checkout'; } else { echo 'Log In'; } ?>"/>
					</div>
				</form>
			</div>
			<?php if ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) { ?>

			<div class="form-wrapper space-1">
				<header class="subhead subhead_dropdown<?php if ( isset($guestErr) ) { ?> active<?php } ?>">
					<a href="#">
						<h3 class="space-1">Just visiting?</h3>
						<p>Shop without creating an account.</p>
					</a>
				</header>
				<form id="guestForm" class="standard_form reveal" action="" method="POST"<?php if ( isset($guestErr) ) { ?> style="display: block;"<?php } ?>>
					<?php if ( isset($guestErr) ) { ?>
						<div class="alert alert-error"><?php echo $guestErr; ?></div>
					<?php } ?>
					<div class="row space-1">
						<label for="guest_email"><?php _e('Email'); ?></label>
						<input name="guest_email" id="guest_email" class="input required" type="email"/>
					</div>
					<div class="row space-1">
						<div class="row">
							<input class="checkbox" name="marketing" id="guest_marketing" type="checkbox" value="0" />
							<label for="guest_marketing">Opt in to receive marketing communications</label>
						</div>
						<div class="row">
							<input class="checkbox" name="terms" id="guest_terms" type="checkbox" value="0" />
							<label for="guest_terms">I have read and accepted the <a href="<?php echo site_url('privacy'); ?>" target="_blank"><strong>privacy policy</strong></a> and <a href="<?php echo site_url('terms'); ?>" target="_blank"><strong>terms &amp; conditions</strong></a></label>
						</div>
						<div class="row">
							<input class="checkbox" name="age" id="guest_age" type="checkbox" value="0" />
							<label for="guest_age"><strong>I am over 18 years of age</strong></label>
						</div>
					</div>
					<div class="form-row">
						<input type="hidden" name="action" value="guest" />
						<input type="hidden" name="formName" value="guest" />
						<input type="hidden" name="guest_nonce_field" value="<?php echo wp_create_nonce('verify_true_guest'); ?>"/>
						<input type="submit" class="btn btn-primary btn-block" value="<?php _e('Checkout as guest'); ?>"/>
					</div>
				</form>
			</div>
			<?php } ?>

		</div>

		<div class="col-6 col-12-sm pd-h-md">
			<div class="form-wrapper">
				<header class="subhead subhead_dropdown<?php if ( isset($regErr) ) { ?> active<?php } ?>">
					<a href="#">
						<h3 class="space-1">I am a new customer</h3>
						<p>Checkout is faster for registered customers, and allows you to save your details for next time and track your order status in your account.</p>
					</a>
				</header>
				<form id="registerForm" class="standard_form reveal" action="" method="POST"<?php if ( isset($regErr) ) { ?> style="display: block;"<?php } ?>>
					<?php if ( isset($regErr) ) { ?>
					<div class="alert alert-error"><?php echo $regErr; ?></div>
					<?php } ?>
					<div class="row space-1">
						<label for="email"><?php _e('Email'); ?></label>
						<input name="user_email" id="email" class="input required" type="email" value="<?php if ( isset($email) ) { echo $email; } ?>" placeholder="Email Address" />
					</div>
					<div class="row space-1">
						<label for="first_name"><?php _e('First Name'); ?></label>
						<input name="first_name" id="first_name" type="text" class="input" value="<?php if ( isset($first_name) ) { echo $first_name; } ?>" placeholder="First Name" />
					</div>
					<div class="row space-1">
						<label for="surname"><?php _e('Surname'); ?></label>
						<input name="last_name" id="surname" type="text" class="input" value="<?php if ( isset($last_name) ) { echo $last_name; } ?>" placeholder="Surname" />
					</div>
					<div class="row space-1">
						<label for="password"><?php _e('Password'); ?></label>
						<input name="password" id="password" class="input required" type="password" placeholder="Password" />
					</div>
					<div class="row space-1">
						<label for="verify_password"><?php _e('Verify Password'); ?></label>
						<input name="verify_password" id="verify_password" class="input required" type="password" placeholder="Verify Password" />
					</div>
					<div class="row space-1">
						<div class="row">
							<input class="checkbox" name="marketing" id="marketing" type="checkbox" value="0" />
							<label for="marketing">Opt in to receive marketing communications</label>
						</div>
						<div class="row">
							<input class="checkbox" name="terms" id="terms" type="checkbox" value="0" />
							<label for="terms">I have read and accepted the <a href="<?php echo site_url('privacy'); ?>" target="_blank"><strong>privacy policy</strong></a> and <a href="<?php echo site_url('terms'); ?>" target="_blank"><strong>terms &amp; conditions</strong></a></label>
						</div>
						<div class="row">
							<input class="checkbox" name="age" id="age" type="checkbox" value="0" />
							<label for="age"><strong>I am over 18 years of age</strong></label>
						</div>
					</div>
					<div class="form-row">
						<input type="hidden" name="action" value="register" />
						<input type="hidden" name="formName" value="register" />
						<input type="hidden" name="register_nonce_field" value="<?php echo wp_create_nonce('verify_true_register'); ?>"/>
						<input type="submit" class="btn btn-primary btn-block" value="<?php if ( !empty( $_GET['done'] ) && $_GET['done'] == 'checkout' ) { echo 'Sign Up & Checkout'; } else { echo 'Sign Up'; } ?>"/>
					</div>
				</form>
			</div>
		</div>

	</div>

</div>
<?php get_footer(); ?>